/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* CE2_ECDH_SVDP_DH function. 
*
* \version CE2_ECPKI_DH.c#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_ECPKI_DH.h"
#include "LLF_ECPKI_DH.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_ECDH_SVDP_DH
*
* Inputs:
* @param BuildedPartnerPublKey_ptr [in] - A pointer to a partner public key. 
* @param UserPrivKey_ptr [in] - A pointer to a user private key.
* @param SharedSecretValue_ptr [out] - A pointer to an output buffer that will 
*                          contain the shared secret value.
* @param SharedSecrValSize_ptr [in\out] - A pointer to the size of user passed 
*                          buffer (in) and actual output size of 
*                          calculated shared secret value.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECPKI_SVDP_DH_INVALID_BUILDED_PARTNER_PUBLIC_KEY_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_USER_PRIVATE_KEY_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_DOMAIN_ID_ERROR
*
* \brief \b 
* Description:
*  Creates the shared secret value accordingly to the IEEE 1363-2000 
*  standard.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECDH_SVDP_DH 
*     for creation of shared secret with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_ECDH_SVDP_DH( 
						CE2_ECPKI_UserPublKey_t *BuildedPartnerPublKey_ptr, /*in*/
						CE2_ECPKI_UserPrivKey_t *UserPrivKey_ptr,           /*in*/							                
						DxUint8_t		 *SharedSecretValue_ptr,     /*out*/
						DxUint32_t               *SharedSecrValSize_ptr    /*in/out*/)
{
  if (BuildedPartnerPublKey_ptr == DX_NULL)
    return CE2_ECPKI_SVDP_DH_INVALID_BUILDED_PARTNER_PUBLIC_KEY_PTR_ERROR;

  if (UserPrivKey_ptr == DX_NULL)
    return CE2_ECPKI_SVDP_DH_INVALID_USER_PRIVATE_KEY_PTR_ERROR;

  if (SharedSecretValue_ptr == DX_NULL)
    return CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_PTR_ERROR;

  if (SharedSecrValSize_ptr == DX_NULL)
    return CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_PTR_ERROR;

  if(BuildedPartnerPublKey_ptr->DomainID != UserPrivKey_ptr->DomainID)
    return CE2_ECPKI_SVDP_DH_INVALID_DOMAIN_ID_ERROR;

  return LLF_ECDH_SVDP_DH(BuildedPartnerPublKey_ptr, UserPrivKey_ptr, 
    SharedSecretValue_ptr, SharedSecrValSize_ptr);
} /* End of LLF_ECDH_SVDP_DH */

